#ifndef __INNO_ASWS_NH_IM_H__
#define __INNO_ASWS_NH_IM_H__

// Version: 1.0.0.5

#define Use_ASWS		//  Use_ASWS, Not Use_ASWS

#ifdef DLLAPI_EXPORT
#define API extern "C" __declspec(dllexport)
#else
#define API extern "C" __declspec(dllimport)
#endif

enum ASWS_STATUS
{
	NoError_Error = 0,				// error - UnKnown.
	NoError_OK,						// Complete.
	NoError_Fail_Servo = -1,		// error - Servo off.
	NoError_Fail_Proper = -2,		// error - property read.

	STATUS_OVERLOAD_ERROR = -3,
	STATUS_COMMUNICATION_ERROR = -2,
	STATUS_UNKNWON = -1,
	STATUS_POWERDOWN = 0,
	STATUS_INIT,
	STATUS_POWERON,	
	STATUS_NORMAL,
	STATUS_RUN,
	STATUS_CALIBRATION,
	
	MODE_ITorque = 0,
	MODE_DTorque,
	MODE_DPosition,
	MODE_Default,
};

enum _tagASWS_MotionState
{
	_ERROR_STOP = 1,		// The axis is in abnormal stop state.
	_DISABLE,				// The axis is in the servo off state.
	_STOPPING,				// The axis is stopping.
	_HOMING,				// The axis is referencing.
	_STANDSTILL,			// The axis is waiting for operation. (Standby mode, When calling position mode function)
	_DISCREMOTION,			// The axis is performing a position command.	(When calling position mode function)
	_CONTINUOUSMOTION,		// The axis is performing a speed command. (When calling torque mode function)
	_SYNCHRONIZEDMOTION,	// The axis is performing a synchronous command.
};

#ifdef Use_ASWS

// Main function

// Initialize & Release
API  int expASWS_Thread_Start();														// Execute Kernel initialize, Network Operation, Servo On.
																						// return 1 : Success
API void expASWS_Thread_Stop();															// Execute Stop Kernel, Destroy Kernel, Servo Off

// Setting user input - function
API void expASWS_SetActiveTorque(BOOL Active);											// ASWS Normal -> Run (0: Disable, 1: Active)

// Set Steering Mode
API void expASWS_SetMode(int mode);														// 0: Inno Torque, 1: Direct Torque, 2: Direct Position

// Inno Torque Mode
API void expASWS_SetVehSpeed(float Speed);												// Set Vehicle Speed (Km/h)

// Direct Torque Mode
API void expASWS_SetTorqueValue(float fTorque);											// User input directly torque - Value(-8.59~+8.59 Nm)					

// Direct Position Mode - Real Mode
API void expASWS_SetDirectAngleValue(float fAngle);										// Set Direct Position Steering Angle, -540 ~ 540

// Effect
API void expASWS_SetEffectOnOff(float famp, float fhz, BOOL bActive);					// Sine effect - sine graph
API void expASWS_SetRumbleEffectOnOff(float famp, BOOL bActive);						// Rumble Effect
API void expASWS_SetPotholeEffectOn(float famp);										// Pothole Effect
API void expASWS_SetCollisionEffectOn(float famp);										// Collision Effect
API void expASWS_SetBumpEffectOn(float famp);											// Bump Effect
API void expASWS_SetKerbEffectOn(float famp);											// Kerb Effect

// Getting information - function
API float expASWS_GetSteerAngle();														// Get position (degree)
API float expASWS_GetSteerVelocity();													// Get velocity (degree/s)
API float expASWS_GetSteerInTorque();													// Get Input Torque	(N.m)
API float expASWS_GetSteerOutTorque();													// Get Output Torque (N.m)
API float expASWS_GetSteerPulse();														// Get position	(pulse)	
API unsigned short expASWS_GetErrorNumber();											// Get Error Number
API int expASWS_GetStatus();															// Get Status
API int expASWS_GetMotionStatus();														// Get Motion Status
API int expASWS_GetMode();

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Only Innosimulation Use

// Inno Torque Mode - Tuning Mode Active
API void expASWS_SetTuningMode(BOOL bActive);

// Direct Position Mode - Tuning Mode
API void expASWS_SetDirectAngleTuningValue(float fVelocity, float fAngle, float fAcceleration, float fDeceleration, float fJerk);

// Other functions (Optional - Only Use InnoSimulation)	
API void expASWS_ReadParameters();
API void expASWS_SaveParameters(struct Mod_COEF *coef);
API void expASWS_SetVehicleParamValue(float fspeed, float fStiffness, float fFriction);

#endif // Use_ASWS

#endif /*__INNO_ASWS_NH_IM_H__*/